/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.debuffs.DebuffType;
import dev.toma.gunsrpg.common.debuffs.DynamicDebuff;
import dev.toma.gunsrpg.common.init.ModRegistries;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public final class DebuffDataManager
extends JsonReloadListener {
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, Object> debuffData = new HashMap<ResourceLocation, Object>();

    public DebuffDataManager() {
        super(GSON, "debuff");
    }

    public Map<ResourceLocation, Object> getDebuffData() {
        return this.debuffData;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, IResourceManager manager, IProfiler profiler) {
        this.debuffData.clear();
        for (DebuffType type : ModRegistries.DEBUFFS) {
            if (!(type instanceof DynamicDebuff)) continue;
            this.loadDebuffData(data, type);
        }
    }

    private <S> void loadDebuffData(Map<ResourceLocation, JsonElement> data, DebuffType<?> debuffType) {
        DynamicDebuff dynDebuff = (DynamicDebuff)((Object)debuffType);
        ResourceLocation identifier = debuffType.getRegistryName();
        JsonElement element = data.get(identifier);
        if (element == null) {
            GunsRPG.log.fatal("Unable to load debuff data for {} debuff, no data found", (Object)identifier);
            throw new IllegalStateException("Missing debuff data");
        }
        Codec dataCodec = dynDebuff.getDataCodec();
        DataResult dataResult = dataCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
        Object dataSource = dataResult.resultOrPartial(arg_0 -> ((Logger)GunsRPG.log).error(arg_0)).orElseThrow(() -> new IllegalStateException("Invalid data received for " + identifier + " debuff"));
        dynDebuff.onDataLoaded(dataSource);
        this.debuffData.put(identifier, dataSource);
    }
}

